package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.web.model.MyGoalTaskActivity;

@Component
public class MyGoalTaskActivityConverter implements Converter<MyGoalsTaskActivitiesDTO, MyGoalTaskActivity>, Serializable {
	private static final long serialVersionUID = 1L;

	@Override
	public MyGoalTaskActivity convert(MyGoalsTaskActivitiesDTO dto) {
		MyGoalTaskActivity model = new MyGoalTaskActivity();
		
		model.setActivityDate(dto.getActivityDate());
		model.setOplock(dto.getOplock());
		model.setTaskActivityId(dto.getTaskActivityId());
		model.setTaskRepetitionCycleType(dto.getTaskRepetitionCycleType());
		model.setUpdatedTime(dto.getUpdatedTime());
		
		return model;
	}

}
